dofile(LockOn_Options.common_script_path..'Radio.lua')
dofile(LockOn_Options.common_script_path.."mission_prepare.lua")

local gettext = require("i_18n")
_ = gettext.translate

device_timer_dt = 0.2

innerNoise 			= getInnerNoise(2.5E-6, 10.0)--V/m (dB S+N/N)
innerNoise_108_116_MHz_coeff = 1.2
frequency_accuracy 	= 500.0				--Hz
band_width			= 12E3				--Hz (6 dB selectivity)
power 				= 10.0				--Watts

agr = {
	input_signal_deviation		= rangeUtoDb(4E-6, 0.5), --Db
	output_signal_deviation		= 5 - (-4),  --Db
	input_signal_linear_zone 	= 10.0, --Db
	regulation_time				= 0.25, --sec
}

GUI = {
	ranges = {
		[1] = {min = 30.E6, max = 87.975E6, step = 25E3},
		[2] = {min = 108.E6, max = 173.975E6, step = 25E3},
		[3] = {min = 225.E6, max = 399.975E6, step = 25E3},
		},
	displayName = _('VHF/UHF ARC-182'),
	AM = true,
	FM = true,
}

-- VHF/UHF ARC-182

-- 255 = 255.000
-- 255.25 = 255.250
-- 255.5 = 255.500
-- 255.75 = 255.750

presets = {
    [1] = 250,
    [2] = 260,
    [3] = 270,
    [4] = 255,
    [5] = 259,
    [6] = 251,
    [7] = 257,
    [8] = 253,
    [9] = 254,
    [10] = 264,
    [11] = 266,
    [12] = 265,
    [13] = 252,
    [14] = 261,
    [15] = 256,
    [16] = 268,
    [17] = 258,
    [18] = 267,
    [19] = 269,
    [20] = 261,
    [21] = 127,
    [22] = 127.025,
    [23] = 127.050,
    [24] = 127.1,
    [25] = 127.125,
    [26] = 127.15,
    [27] = 127.175,
    [28] = 127.2,
    [29] = 127.225,
    [30] = 127.25,
}

  for i = 1,30 do
      presets[i] = (presets[i] or 255) * 1e6
  end

goniometer = {isLagElement = true, T1 = 0.3, bias = {{valmin = math.rad(0), valmax = math.rad(360), bias = math.rad(1)}}}

VHF_ARC_182_FAILURE_TOTAL = 0
VHF_ARC_182_FAILURE_DISPLAY = 1
VHF_ARC_182_FAILURE_REMOTE_DISPLAY = 2
VHF_ARC_182_FAILURE_INTERNAL_MODULE = 3
VHF_ARC_182_FAILURE_TRANSCEIVER = 4
VHF_ARC_182_FAILURE_ANTENNA = 5

Damage = { {Failure = VHF_ARC_182_FAILURE_TOTAL, Failure_name = "VHF_ARC_182_FAILURE_TOTAL", Failure_editor_name = _("VHF/UHF AN/ARC-182: Total"), Element = "AVX_004", Integrity_Treshold = 0.0, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*250},
   {Failure = VHF_ARC_182_FAILURE_DISPLAY, Failure_name ="VHF_ARC_182_FAILURE_DISPLAY", Failure_editor_name = _("VHF/UHF AN/ARC-182: Display"), Element = "AVX_WALL_LEFT_REAR", Integrity_Treshold = 0.6, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*250},
   {Failure = VHF_ARC_182_FAILURE_REMOTE_DISPLAY, Failure_name = "VHF_ARC_182_FAILURE_REMOTE_DISPLAY", Failure_editor_name = _("VHF/UHF AN/ARC-182: Remote Display"), Element = "DASHBOARD_PILOT", Integrity_Treshold = 0.8, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*250},
   {Failure = VHF_ARC_182_FAILURE_INTERNAL_MODULE, Failure_name = "VHF_ARC_182_FAILURE_INTERNAL_MODULE", Failure_editor_name = _("VHF/UHF AN/ARC-182: Internal Module"), Element = "AVX_004", Integrity_Treshold = 0.25, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*250},
   {Failure = VHF_ARC_182_FAILURE_TRANSCEIVER, Failure_name = "VHF_ARC_182_FAILURE_TRANSCEIVER", Failure_editor_name = _("VHF/UHF AN/ARC-182: Transceiver"), Element = "AVX_004", Integrity_Treshold = 0.25, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*250},
   {Failure = VHF_ARC_182_FAILURE_ANTENNA, Failure_name = "VHF_ARC_182_FAILURE_ANTENNA", Failure_editor_name = _("VHF/UHF AN/ARC-182: Antenna"), Element = "TACAN", Integrity_Treshold = 0.5, work_time_to_fail_probability = 0.5, work_time_to_fail = 3600*250}
}

need_to_be_closed = true -- close lua state after initialization 
